using System;
using System.Collections.Generic;

namespace _6Baki_i_Srecko
{
    internal class Program
    {
        struct Pomeraj
        {
            public double angle;
            public int i;
            public int type; // +1 = ukljuci, -1 = iskljuci
        }
        static int PorediPomeraje(Pomeraj a, Pomeraj b)
        {
            if (a.angle < b.angle) return -1;
            if (a.angle > b.angle) return 1;
            return 0;
        }

        static void Main()
        {
            int n = int.Parse(Console.ReadLine());
            long[] x = new long[n];
            long[] y = new long[n];

            for (int i = 0; i < n; i++)
            {
                string[] s = Console.ReadLine().Split();
                x[i] = long.Parse(s[0]);
                y[i] = long.Parse(s[1]);
            }

            List<Pomeraj> list = new List<Pomeraj>(2 * n);

            for (int i = 0; i < n; i++)
            {
                double ang = Math.Atan2(y[i], x[i]);

                double enter = ang - Math.PI / 2;
                double exit = ang + Math.PI / 2;

                if (enter < -Math.PI) enter += 2 * Math.PI;
                if (exit > Math.PI) exit -= 2 * Math.PI;

                list.Add(new Pomeraj { angle = enter, i = i, type = +1 });
                list.Add(new Pomeraj { angle = exit, i = i, type = -1 });
            }

            list.Sort(PorediPomeraje);

            bool[] active = new bool[n];
            bool[] bestActive = new bool[n];

            long curX = 0;
            long curY = 0;
            long bestX = 0;
            long bestY = 0;

            foreach (Pomeraj e in list)
            {
                int ind = e.i;

                if (e.type == +1)
                {
                    active[ind] = true;
                    curX += x[ind];
                    curY += y[ind];
                }
                else
                {
                    active[ind] = false;
                    curX -= x[ind];
                    curY -= y[ind];
                }

                long dist = curX * curX + curY * curY;
                long maxDist = bestX * bestX + bestY * bestY;

                if (dist > maxDist)
                {
                    bestX = curX;
                    bestY = curY;
                    active.CopyTo(bestActive, 0);
                }
            }


            List<int> res = new List<int>();
            for (int i = 0; i < n; i++)
                if (bestActive[i])
                    res.Add(i + 1);

            Console.WriteLine(res.Count);
            for (int i = 0; i < res.Count; i++)
                Console.Write(res[i] + " ");
            Console.WriteLine();
        }
    }
}